attribute vec2 a_position;
attribute vec4 a_color;
attribute vec2 a_texcoord;

uniform mat4 u_modelMtx;
uniform mat4 u_viewMtx;
uniform mat4 u_projMtx;

uniform vec4 u_blendcolor;

varying vec4 v_texcoord[5/2];

void main()
{
	int samples = 5;
	float offset[5];
	offset[0] = -0.5;
	offset[1] = -0.2;
	offset[2] =  0.0;
	offset[3] =  0.2;
	offset[4] =  0.5;

	for (int i=0; i<samples/2; i++)
	{
		v_texcoord[i].xy = a_texcoord + offset[i*2];
		v_texcoord[i].zw = a_texcoord + offset[i*2+1];
	}
	
	// gl_FrontColor = a_color;
	gl_Position = u_projMtx * u_viewMtx * u_modelMtx * vec4(a_position,0.0,1.0);

	// Transforming The Vertex
	// gl_Position = ftransform();
} 
